package com.company.views;

import com.company.exceptions.InvalidDataException;
import com.company.model.*;
import javafx.util.Pair;

import java.util.Iterator;
import java.util.List;

public class EnrollView {
    public static Enroll getEnroll(StudentContainer students, SubjectContainer subjects){
        //this is very dangerous
        Enroll enroll = new Enroll(1, null, null);
        boolean flag = false;
        do{
            try{
                flag = false;
                System.out.print("Enroll"+"\n");
                int number = Utils.getNumber("Enter Student Number");
                Student student = students.get(number);
                enroll.setStudent(student);
                String initials = Utils.getString("Enter Subject Initials");
                Subject subject = subjects.get(initials);
                enroll.setSubject(subject);
                int grade = Utils.getNumber("Enter Enroll Grade");
                enroll.setGrade(grade);

            }catch(InvalidDataException e){
                flag = true;
            }
        }while(flag == true);
        return enroll;
    }

    public static void  printEnroll(Enroll enroll){
        Student student = enroll.getStudent();
        Subject subject = enroll.getSubject();
        System.out.print(student.getNumber()+":"+student.getName()+":"+subject.getInitials()+":"+subject.getDesignation()+":"+enroll.getGrade()+"\n");
    }
    public static void  printEnrolls( List<Enroll> enrolls){
        Enroll enroll;
        Iterator<Enroll> it = enrolls.iterator();
        while(it.hasNext()){
            enroll = it.next();
            printEnroll(enroll);
        }
    }

    public static void  printStudentEnrolls(Student  student,List<Pair<Subject, Integer>> subjects){
        System.out.print(student.getNumber()+":"+student.getName()+"\n");
        Pair<Subject, Integer>  item;
        Iterator<Pair<Subject, Integer>> it = subjects.iterator();
        while(it.hasNext()){
            item = it.next();
            Subject subject = item.getKey();
            int grade = item.getValue();
            System.out.print("\t"+subject.getInitials()+":"+subject.getDesignation()+":"+grade+"\n");

        }
    }
    public static void  printSubjectEnrolls(Subject subject, List<Pair<Student, Integer>>  students){
        System.out.print(subject.getInitials()+":"+subject.getDesignation()+"\n");
        Pair<Student, Integer>  item;
        Iterator<Pair<Student, Integer>> it = students.iterator();
        while(it.hasNext()){
            item = it.next();
            Student student = item.getKey();
            int grade = item.getValue();
            System.out.print("\t"+student.getNumber()+":"+student.getName()+":"+grade+"\n");
        }
    }
    public static void  printError(String error){
        System.out.println(error);
    }
}
